import { ActionType } from '../action-types';
export const openLookupDialog = (field) => async (dispatch, getState) => {
    await dispatch({ type: ActionType.OpenLookupDialog, value: field });
    const updatedState = getState();
    updatedState.applicationContext?.updateMenu(updatedState.menuItems);
    updatedState.applicationContext?.onTelemetryEvent?.(`lookupOpened-${field.elementId}`, {
        elementId: field.elementId,
    });
};
export const closeLookupDialog = () => async (dispatch, getState) => {
    await dispatch({ type: ActionType.CloseLookupDialog, value: null });
    const updatedState = getState();
    updatedState.applicationContext?.updateMenu(updatedState.menuItems);
};
//# sourceMappingURL=current-lookup-dialog.js.map