import Typography from 'carbon-react/esm/components/typography';
import * as React from 'react';
import { connect } from 'react-redux';
import { localize } from '../../../service/i18n-service';
import { ChartWidgetContent } from './chart-widget-content';
import { IndicatorWidgetContent } from './indicator-tile-widget-content';
import { TableWidgetContent } from './table-widget-content';
export function ContentStep({ browserIs, nodeNames, onWidgetDefinitionUpdated, stepIndex, widgetDefinition, }) {
    return (React.createElement("div", null,
        React.createElement(Typography, { variant: "h2", "data-testid": "e-widget-editor-step-title" }, localize('@sage/xtrem-ui/widget-editor-content-step-title', '{{stepIndex}}. Add your content', {
            stepIndex,
        })),
        React.createElement("div", { className: "e-widget-editor-section" },
            widgetDefinition.type === 'INDICATOR_TILE' && (React.createElement(IndicatorWidgetContent, { browserIs: browserIs, nodeNames: nodeNames, onWidgetDefinitionUpdated: onWidgetDefinitionUpdated, widgetDefinition: widgetDefinition })),
            widgetDefinition.type === 'TABLE' && (React.createElement(TableWidgetContent, { browserIs: browserIs, nodeNames: nodeNames, onWidgetDefinitionUpdated: onWidgetDefinitionUpdated, widgetDefinition: widgetDefinition })),
            (widgetDefinition.type === 'BAR_CHART' || widgetDefinition.type === 'LINE_CHART') && (React.createElement(ChartWidgetContent, { browserIs: browserIs, nodeNames: nodeNames, onWidgetDefinitionUpdated: onWidgetDefinitionUpdated, widgetDefinition: widgetDefinition })))));
}
const mapStateToProps = (state, props) => {
    return {
        ...props,
        browserIs: state.browser.is,
    };
};
export const ConnectedContentStep = connect(mapStateToProps)(ContentStep);
//# sourceMappingURL=index.js.map