import * as React from 'react';
const ConnectedWidgetEditorDialog = React.lazy(() => import('./widget-editor-dialog').then(m => ({ default: m.ConnectedWidgetEditorDialog })));
export function AsyncConnectedWidgetEditorDialog(props) {
    /**
     * No fallback component is used because the widget editor dialog is mounted first in a closed state.
     */
    return (React.createElement(React.Suspense, { fallback: React.createElement("span", null) },
        React.createElement(ConnectedWidgetEditorDialog, { ...props })));
}
//# sourceMappingURL=async-widget-editor-dialog.js.map