import * as React from 'react';
import type { Dashboard, Dict, Locale } from '@sage/xtrem-shared';
import type { WidgetDefinition } from './widgets/abstract-widget';
import type { WidgetPosition } from '../redux/actions/dashboard-editor-actions';
import type { DashboardContextVariables } from './dashboard-types';
export interface DashboardEditorDialogExternalProps {
    contextVariables?: DashboardContextVariables;
    group: string;
}
export interface DashboardEditorDialogProps extends DashboardEditorDialogExternalProps {
    canEditDashboards: boolean;
    currentDashboardDefinition: Dashboard;
    dashboardDefinition: Dashboard;
    isDirty: boolean;
    isNavigationPanelOpened: boolean;
    isOpen?: boolean;
    isRedoDisabled: boolean;
    isUndoDisabled: boolean;
    loadingDashboards: boolean;
    locale: Locale;
    onClose: () => void;
    redoDashboardEditor: () => void;
    removeDashboardEditorWidget: (widgetId: string) => void;
    saveDashboardEditorState: () => Promise<void>;
    setNavigationPanelIsOpened: (newState: boolean) => void;
    undoDashboardEditor: () => void;
    updateDashboardEditorWidgetPositions: (widgets: WidgetPosition[]) => void;
    updateDashboardTitleInEditor: (newTitle: string) => void;
    widgets: Dict<WidgetDefinition>;
}
export declare function DashboardEditorDialog({ canEditDashboards, contextVariables, currentDashboardDefinition, dashboardDefinition, group, isDirty, isNavigationPanelOpened, isOpen, isRedoDisabled, isUndoDisabled, loadingDashboards, locale, onClose, redoDashboardEditor, removeDashboardEditorWidget, saveDashboardEditorState, setNavigationPanelIsOpened, undoDashboardEditor, updateDashboardEditorWidgetPositions, updateDashboardTitleInEditor, widgets, }: DashboardEditorDialogProps): React.ReactElement;
export declare const ConnectedDashboardEditorDialog: import("react-redux").ConnectedComponent<typeof DashboardEditorDialog, {
    contextVariables?: DashboardContextVariables | undefined;
    group: string;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=dashboard-editor-dialog.d.ts.map