import type { DialogSizes } from 'carbon-react/esm/components/dialog';
import * as React from 'react';
import type { DashboardContextVariables } from './dashboard-types';
export interface DashboardCreateDialogExternalProps {
    group: string;
    isOpen: boolean;
    contextVariables?: DashboardContextVariables;
    onClose: () => void;
    onNextClicked: (success: boolean) => void;
}
export interface DashboardCreateDialogProps extends DashboardCreateDialogExternalProps {
    cloneDashboard: (dashboardId: string) => Promise<void>;
    createDashboard: () => Promise<void>;
    dialogSize: DialogSizes;
}
export declare function DashboardCreateDialog({ cloneDashboard, createDashboard, dialogSize, group, isOpen, onClose, onNextClicked, }: DashboardCreateDialogProps): React.ReactElement;
export declare const ConnectedDashboardCreateDialog: import("react-redux").ConnectedComponent<typeof DashboardCreateDialog, {
    group: string;
    isOpen: boolean;
    contextVariables?: DashboardContextVariables | undefined;
    onClose: () => void;
    onNextClicked: (success: boolean) => void;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=dashboard-create-dialog.d.ts.map