import React from 'react';
import type { OptionsMenuItem, TableOptionsMenuType } from '../../container/page/page-types';
import type { OnTelemetryEventFunction } from '../../../redux/state';
export interface TableOptionsMenuExternalProps {
    elementId: string;
    onSelectionChange: (selectedItem: OptionsMenuItem) => void;
    optionsMenuItems: OptionsMenuItem[];
    optionsMenuType?: TableOptionsMenuType;
    screenId: string;
    selectedOptionsMenuItem?: OptionsMenuItem;
    onTelemetryEvent?: OnTelemetryEventFunction;
}
export interface TableOptionsMenuProps extends TableOptionsMenuExternalProps {
    setTableViewOptionsMenuItem: (optionsMenuItem: OptionsMenuItem) => void;
}
export declare function TableOptionsMenu({ elementId, onSelectionChange, optionsMenuItems, optionsMenuType, screenId, selectedOptionsMenuItem, setTableViewOptionsMenuItem, onTelemetryEvent, }: TableOptionsMenuProps): React.ReactElement | null;
export declare const ConnectedTableOptionsMenu: import("react-redux").ConnectedComponent<typeof TableOptionsMenu, {
    elementId: string;
    onSelectionChange: (selectedItem: OptionsMenuItem) => void;
    optionsMenuItems: OptionsMenuItem[];
    optionsMenuType?: TableOptionsMenuType | undefined;
    screenId: string;
    selectedOptionsMenuItem?: OptionsMenuItem<any> | undefined;
    onTelemetryEvent?: OnTelemetryEventFunction | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=table-options-menu.d.ts.map