import * as React from 'react';
import type { OnTelemetryEventFunction } from '../../../../redux/state';
import type { CollectionValue } from '../../../../service/collection-data-service';
import type { AccessBindings } from '../../../../service/page-definition';
import type { NestedRecordId } from '../../../../types';
import type { GridRowActionType } from '../../../types';
import type { TableDropdownActionsCellProps } from '../cell/table-dropdown-action-cell';
import type { CollectionPropertiesWithActions } from './table-dropdown-action-types';
export interface TableDropdownActionExternalProps {
    actions?: GridRowActionType;
    api?: TableDropdownActionsCellProps['api'];
    column?: TableDropdownActionsCellProps['column'];
    fieldId: string;
    hasDropdownActions?: boolean;
    hasInlineActions?: boolean;
    isDisabled?: boolean;
    isEditing?: boolean;
    isPhantomRow?: boolean;
    level: number;
    onTelemetryEvent?: OnTelemetryEventFunction;
    recordId: NestedRecordId;
    rowIndex?: TableDropdownActionsCellProps['node']['rowIndex'];
    rowValue: any;
    screenId: string;
    stopEditing?: TableDropdownActionsCellProps['stopEditing'];
}
export interface TableDropdownActionProps extends TableDropdownActionExternalProps {
    fieldProperties: CollectionPropertiesWithActions;
    tableData: CollectionValue;
    accessBindings: AccessBindings;
    rowValue: any;
}
export declare function TableDropdownActions({ accessBindings, api, column, fieldId, fieldProperties, hasInlineActions, isDisabled, isEditing, isPhantomRow, level, recordId, rowIndex, rowValue, screenId, stopEditing, tableData, onTelemetryEvent, }: TableDropdownActionProps): React.ReactNode;
declare const _default: import("react-redux").ConnectedComponent<typeof TableDropdownActions, {
    actions?: GridRowActionType | undefined;
    api?: import("@ag-grid-community/core").GridApi<any> | undefined;
    column?: import("@ag-grid-community/core").Column<any> | undefined;
    fieldId: string;
    hasDropdownActions?: boolean | undefined;
    hasInlineActions?: boolean | undefined;
    isDisabled?: boolean | undefined;
    isEditing?: boolean | undefined;
    isPhantomRow?: boolean | undefined;
    level: number;
    onTelemetryEvent?: OnTelemetryEventFunction | undefined;
    recordId: string;
    rowIndex?: number | null | undefined;
    rowValue: any;
    screenId: string;
    stopEditing?: ((suppressNavigateAfterEdit?: boolean | undefined) => void) | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default _default;
//# sourceMappingURL=table-dropdown-actions.d.ts.map