import type { ClientNode } from '@sage/xtrem-client';
import type { ButtonProps } from 'carbon-react/esm/components/button';
import type { NestedRecordId, ScreenExtension } from '../../../../types';
import type { MenuSeparatorType } from '../../../control-objects';
import type { CollectionActionAccessConfiguration, HasGenericErrorHandler, HasIcon } from '../../../field/traits';
import type { CollectionItem, PartialCollectionValueWithIds } from '../../../types';
export interface CollectionPropertiesWithActions extends HasGenericErrorHandler<any> {
    dropdownActions?: Array<CollectionItemAction<any> | MenuSeparatorType>[];
    inlineActions?: Array<InlineCollectionItemAction<any>>[];
    levels?: {
        dropdownActions: any[];
        inlineActions: any;
    }[];
}
export interface CollectionItemAction<CT extends ScreenExtension<CT>, NestedRecordType = CollectionItem> extends HasIcon, HasGenericErrorHandler<CT> {
    access?: CollectionActionAccessConfiguration;
    id?: string;
    isDestructive?: boolean;
    isDisabled?: (this: CT, recordId: NestedRecordId, rowItem: PartialCollectionValueWithIds<NestedRecordType>) => boolean;
    isDisplayed?: (this: CT, recordId: NestedRecordId, rowItem: PartialCollectionValueWithIds<NestedRecordType>) => boolean;
    isHidden?: (this: CT, recordId: NestedRecordId, rowItem: PartialCollectionValueWithIds<NestedRecordType>) => boolean;
    onClick: (this: CT, recordId: NestedRecordId, rowItem: PartialCollectionValueWithIds<NestedRecordType>) => void;
    title: string;
}
export interface CollectionItemActionGroup<CT extends ScreenExtension<CT>, NestedRecordType = CollectionItem> extends HasIcon, HasGenericErrorHandler<CT> {
    access?: CollectionActionAccessConfiguration;
    children?: Array<CollectionItemAction<CT, NestedRecordType> | MenuSeparatorType | CollectionItemActionGroup<CT, NestedRecordType>>;
    isDisabled?: (this: CT, recordId: NestedRecordId, rowItem: PartialCollectionValueWithIds<NestedRecordType>) => boolean;
    isHidden?: (this: CT, recordId: NestedRecordId, rowItem: PartialCollectionValueWithIds<NestedRecordType>) => boolean;
    title: string;
}
export interface InlineCollectionItemAction<CT extends ScreenExtension<CT>, NestedRecordType = CollectionItem> extends CollectionItemAction<CT, NestedRecordType> {
    buttonType?: ButtonProps['buttonType'];
    isMajor?: boolean;
}
export interface NestedCollectionItemAction<CT extends ScreenExtension<CT>, NestedRecordType extends ClientNode = any> extends HasIcon, HasGenericErrorHandler<CT> {
    access?: CollectionActionAccessConfiguration;
    id?: string;
    isDestructive?: boolean;
    isDisabled?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType, level?: number, parentIds?: NestedRecordId[]) => boolean;
    isHidden?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType, level?: number, parentIds?: NestedRecordId[]) => boolean;
    onClick: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType, level?: number, parentIds?: NestedRecordId[]) => void;
    title: string;
}
export interface NestedCollectionItemActionGroup<CT extends ScreenExtension<CT>, NestedRecordType extends ClientNode = any> extends HasIcon, HasGenericErrorHandler<CT> {
    access?: CollectionActionAccessConfiguration;
    children?: Array<NestedCollectionItemAction<CT, NestedRecordType> | MenuSeparatorType | NestedCollectionItemActionGroup<CT, NestedRecordType>>;
    isDisabled?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType, level?: number, parentIds?: NestedRecordId[]) => boolean;
    isHidden?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType, level?: number, parentIds?: NestedRecordId[]) => boolean;
    title: string;
}
//# sourceMappingURL=table-dropdown-action-types.d.ts.map