import * as React from 'react';
import { localize } from '../../../../../service/i18n-service';
/**
 * This floating filter component is used to display the currently selected items for reference fields in the header using a comma separated list.
 */
export const ReferenceFloatingFilter = React.forwardRef((_props, ref) => {
    const [displayValue, setDisplayValue] = React.useState('');
    // expose AG Grid Filter Lifecycle callbacks
    React.useImperativeHandle(ref, () => {
        return {
            onParentModelChanged(parentModel) {
                const displayValues = parentModel?.displayValues;
                if (Array.isArray(displayValues) && displayValues.length > 0) {
                    setDisplayValue(`(${displayValues.length}) ${displayValues.join(', ')}`);
                }
                else {
                    setDisplayValue('');
                }
            },
        };
    });
    /**
     * This DOM structure was copied from AG-Grid's `SetFilter` to ensure it has the same look and feel.
     */
    return (React.createElement("div", { className: "ag-floating-filter-input", role: "presentation" },
        React.createElement("div", { role: "presentation", className: "ag-labeled ag-label-align-left ag-text-field ag-input-field ag-disabled" },
            React.createElement("div", { className: "ag-input-field-label ag-label ag-hidden ag-text-field-label", role: "presentation" }),
            React.createElement("div", { className: "ag-wrapper ag-input-wrapper ag-text-field-input-wrapper", role: "presentation" },
                React.createElement("input", { className: "ag-input-field-input ag-text-field-input", "aria-label": localize('@sage/xtrem-ui/table-filter-aria-label', 'Filter'), type: "text", disabled: true, value: displayValue })))));
});
ReferenceFloatingFilter.displayName = 'ReferenceFloatingFilter';
export default ReferenceFloatingFilter;
//# sourceMappingURL=reference-floating-filter.js.map