import { RANGE } from '@sage/xtrem-shared';
import React from 'react';
import { isEqual, isNil } from 'lodash';
import { useDeepCompareEffect } from '@sage/xtrem-ui-components';
import { FilterTypeSelect } from '../filter-type-select-component';
import { getModelFromNumericFilterState, getNumericFilterStateFromModel } from './numeric-filter-utils';
import { NumericFilterInput } from './numeric-filter-input';
export default function NumericFilter({ model, onModelChange, column }) {
    const screenId = React.useMemo(() => column.getColDef().screenId, [column]);
    const scale = React.useMemo(() => column.getColDef().cellEditorParams?.fieldProperties?.scale, [column]);
    const [numericFilterState, setNumericFilterState] = React.useState(() => getNumericFilterStateFromModel(model));
    useDeepCompareEffect(() => {
        const newDateState = getNumericFilterStateFromModel(model);
        if (!isEqual(numericFilterState, newDateState)) {
            setNumericFilterState(newDateState);
        }
    }, [model]);
    const onChange = React.useCallback((newValue) => {
        const nextState = { ...numericFilterState, ...newValue };
        setNumericFilterState(nextState);
        if (isNil(nextState.value) && model !== null) {
            onModelChange(null);
        }
        const updatedModel = getModelFromNumericFilterState(nextState);
        if (!isNil(nextState.value) && !isEqual(updatedModel, model)) {
            onModelChange(updatedModel);
        }
    }, [model, numericFilterState, onModelChange]);
    const handleChange = React.useCallback((updatedValue) => {
        onChange({ value: updatedValue || undefined });
    }, [onChange]);
    const handleChangeTo = React.useCallback((updatedValue) => {
        onChange({ valueTo: updatedValue || undefined });
    }, [onChange]);
    const onFilterTypeChanged = React.useCallback((item) => {
        const newValue = item.value;
        onChange({ type: newValue });
    }, [onChange]);
    return (React.createElement("div", { className: "e-filter-numeric-container" },
        React.createElement(FilterTypeSelect, { onChange: onFilterTypeChanged, value: numericFilterState.type }),
        React.createElement(NumericFilterInput, { "data-testid": "e-ui-numeric-filter-input", scale: scale, onChange: handleChange, value: numericFilterState.value ?? null, screenId: screenId }),
        numericFilterState.type === RANGE && (React.createElement(NumericFilterInput, { "data-testid": "e-ui-numeric-filter-input-to", scale: scale, onChange: handleChangeTo, value: numericFilterState.valueTo ?? null, screenId: screenId }))));
}
//# sourceMappingURL=numeric-filter.js.map