import { isNil } from 'lodash';
import { EQUALS } from '@sage/xtrem-shared';
export const defaultNumericFilterState = () => ({
    type: EQUALS,
});
export const getModelFromNumericFilterState = (dateState) => dateState.value
    ? {
        filterType: 'number',
        filter: dateState.value,
        filterTo: dateState.valueTo,
        type: dateState.type,
    }
    : null;
export function getNumericFilterStateFromModel(model) {
    const value = {
        type: EQUALS,
    };
    if (!isNil(model?.filter)) {
        value.value = model.filter;
    }
    if (!isNil(model?.filterTo)) {
        value.valueTo = model.filterTo;
    }
    if (!isNil(model?.type)) {
        value.type = model.type;
    }
    return value;
}
//# sourceMappingURL=numeric-filter-utils.js.map