import { RANGE } from '@sage/xtrem-shared';
import CarbonDate from 'carbon-react/esm/components/date';
import React from 'react';
import { isEqual } from 'lodash';
import { getModelFromDateState, getDateStateFromModel } from './date-filter-utils';
import { isValidIsoDate } from '@sage/xtrem-date-time';
import { useDeepCompareEffect } from '@sage/xtrem-ui-components';
import { FilterTypeSelect } from '../filter-type-select-component';
export default function DateFilter({ model, onModelChange }) {
    const [dateState, setDateState] = React.useState(() => getDateStateFromModel(model));
    useDeepCompareEffect(() => {
        const newDateState = getDateStateFromModel(model);
        if (!isEqual(dateState, newDateState)) {
            setDateState(newDateState);
        }
    }, [model]);
    const onChange = React.useCallback((newValue) => {
        setDateState(current => ({ ...current, ...newValue }));
        const values = Object.values(newValue ?? {});
        if (values.filter(Boolean).length === 0) {
            onModelChange(null);
        }
        if (values.length > 0 && values.some(v => isValidIsoDate(v))) {
            onModelChange(getModelFromDateState({ ...dateState, ...newValue }));
        }
    }, [dateState, onModelChange]);
    const handleChange = React.useCallback((event) => {
        const newValue = event.target.value.rawValue;
        const newFormattedValue = event.target.value.formattedValue;
        onChange({ rawValue: newValue, formattedValue: newFormattedValue });
    }, [onChange]);
    const handleChangeTo = React.useCallback((event) => {
        const newValue = event.target.value.rawValue;
        const newFormattedValue = event.target.value.formattedValue;
        onChange({ rawValueTo: newValue, formattedValueTo: newFormattedValue });
    }, [onChange]);
    const onFilterTypeChanged = React.useCallback((item) => {
        const newValue = item.value;
        onChange({ type: newValue });
    }, [onChange]);
    return (React.createElement("div", { className: "e-filter-date-container" },
        React.createElement(FilterTypeSelect, { onChange: onFilterTypeChanged, value: dateState.type }),
        React.createElement(CarbonDate, { mt: "6px", "data-testid": "e-date-filter", allowEmptyValue: true, onChange: handleChange, value: dateState.formattedValue, size: "small", autoComplete: "off", disablePortal: true, inputWidth: 100 }),
        dateState.type === RANGE && (React.createElement(CarbonDate, { mt: "6px", allowEmptyValue: true, onChange: handleChangeTo, value: dateState.formattedValueTo ?? '', size: "small", autoComplete: "off", disablePortal: true, inputWidth: 100 }))));
}
//# sourceMappingURL=date-filter.js.map