import type { Column } from '@ag-grid-community/core';
import type { EQUALS } from '@sage/xtrem-shared';
export type EventTargetOnDateChange = {
    value: {
        formattedValue: string;
        rawValue: string;
    };
};
export interface DateState {
    rawValue: string;
    formattedValue: string;
    rawValueTo?: string;
    formattedValueTo?: string;
    type: string;
}
export interface SimpleDateModel {
    filterType: 'date';
    dateFrom: string;
    dateTo?: string;
    type: string;
    formattedValue: string;
    formattedValueTo?: string;
}
export interface ComplexDateModel {
    condition1: SimpleDateModel;
    filterType: 'date';
}
export interface SimpleDateEqualModel {
    filterType: typeof EQUALS;
    rawValue: string;
    formattedValue: string;
}
export type DateModel = SimpleDateModel | ComplexDateModel | SimpleDateEqualModel;
export interface DateFilterProps {
    model: DateModel | null;
    onModelChange: (model: DateModel | null) => void;
    column: Column;
}
//# sourceMappingURL=date-filter-types.d.ts.map