import Button from 'carbon-react/esm/components/button';
import MultiActionButton from 'carbon-react/esm/components/multi-action-button';
import * as React from 'react';
import { localize } from '../../../service/i18n-service';
import { useSelector } from 'react-redux';
import * as dialogService from '../../../service/dialog-service';
import { QUERY_PARAM_PRINTING_SOURCE_PAGE } from '../../../utils/constants';
import { navigationPanelId } from '../../container/navigation-panel/navigation-panel-types';
export function DesktopTablePrintButton({ screenId, elementId, }) {
    const printingSettings = useSelector(state => state.printingSettings);
    const openAssignmentDialog = React.useCallback(() => {
        if (!printingSettings?.listPrintingAssignmentWizardUrl) {
            throw new Error('listPrintingAssignmentUrl is not defined');
        }
        dialogService.openPageDialog(printingSettings.listPrintingAssignmentWizardUrl, { [QUERY_PARAM_PRINTING_SOURCE_PAGE]: screenId }, { resolveOnCancel: true, size: 'large' });
    }, [printingSettings?.listPrintingAssignmentWizardUrl, screenId]);
    const openPrintDialog = React.useCallback(() => {
        if (!printingSettings?.listPrintingWizardUrl) {
            throw new Error('listPrintingWizardUrl is not defined');
        }
        dialogService.openPageDialog(printingSettings.listPrintingWizardUrl, { [QUERY_PARAM_PRINTING_SOURCE_PAGE]: screenId }, { resolveOnCancel: true, size: 'medium' });
    }, [printingSettings?.listPrintingWizardUrl, screenId]);
    if (elementId !== navigationPanelId ||
        !printingSettings ||
        (!printingSettings.canAccessListPrintingAssignmentWizard && !printingSettings.canAccessListPrintingWizard)) {
        return null;
    }
    return (React.createElement(MultiActionButton, { text: localize('@sage/xtrem-ui/table-print', 'Print'), "data-testid": "e-print-main-list-button", mr: "16px" },
        React.createElement(Button, { key: "assignment", disabled: !printingSettings.canAccessListPrintingAssignmentWizard, onClick: openAssignmentDialog, "data-testid": "e-print-list-assignment-button" }, localize('@sage/xtrem-ui/list-printing-assignment', 'Assign report')),
        React.createElement(Button, { key: "print", disabled: !printingSettings.canAccessListPrintingWizard, onClick: openPrintDialog, "data-testid": "e-print-list-wizard-button" }, localize('@sage/xtrem-ui/list-printing', 'Select report'))));
}
//# sourceMappingURL=desktop-table-print-button.js.map