import * as React from 'react';
import { localize } from '../../../service/i18n-service';
import Button from 'carbon-react/esm/components/button';
import { connect } from 'react-redux';
import * as xtremRedux from '../../../redux';
import SplitButton from 'carbon-react/esm/components/split-button';
import BusinessAction from '../../container/footer/business-action';
export const DesktopTableAddNewRowButton = React.memo(({ addItemActions = [], elementId, hasSidebar, isDisabled, level, onFocusPhantomRow, openSidebar, screenId, }) => {
    const addItemPhantomRowLabel = localize('@sage/xtrem-ui/add-item-in-line', 'Add item');
    const addItemUsingSidebarLabel = localize('@sage/xtrem-ui/add-item-in-line-using-sidebar', 'Add item in sidebar');
    if (hasSidebar || addItemActions.length > 0) {
        const businessActions = [
            ...(hasSidebar
                ? [
                    // eslint-disable-next-line react/jsx-indent
                    React.createElement(Button, { key: "e-table-button-add-new-row-sidebar", "data-testid": "e-table-button-add-new-row-sidebar", disabled: isDisabled, onClick: () => openSidebar({ screenId, elementId, level }), "aria-label": addItemUsingSidebarLabel, "data-pendoid": `addTableLineWithSidebarButton-${screenId}-${elementId}` }, addItemUsingSidebarLabel),
                ]
                : []),
            ...addItemActions.map(a => (React.createElement(BusinessAction, { key: a.id, screenId: screenId, id: a.id, buttonTypeOverride: "secondary", skipWrapping: true, alwaysTriggerFieldEvent: true }))),
        ];
        return (React.createElement(SplitButton, { "data-testid": "e-table-button-add-new-row-phantom", text: addItemPhantomRowLabel, iconType: "add", onClick: onFocusPhantomRow, disabled: isDisabled, mr: "16px", "data-pendoid": `addTableLineWithPhantomRowButton-${elementId}` }, businessActions));
    }
    return (React.createElement(Button, { "data-testid": "e-table-button-add-new-row-phantom", disabled: isDisabled, iconType: "add", onClick: onFocusPhantomRow, "aria-label": addItemPhantomRowLabel, mr: "16px" }, addItemPhantomRowLabel));
});
DesktopTableAddNewRowButton.displayName = 'DesktopTableAddNewRowButton';
const mapsStateToProps = (_state, props) => ({
    ...props,
    openSidebar: xtremRedux.actions.actionStub,
});
const mapDispatchToProps = (dispatch) => ({
    openSidebar: ({ screenId, elementId, level }) => {
        dispatch(xtremRedux.actions.openTableSidebar({ screenId, elementId, level }));
    },
});
export const ConnectedDesktopTableAddNewRowButton = connect(mapsStateToProps, mapDispatchToProps)(DesktopTableAddNewRowButton);
//# sourceMappingURL=desktop-table-add-new-row-button.js.map