import React from 'react';
export function CheckboxCell({ node, data }) {
    const inputRef = React.useRef(null);
    const [checked, setChecked] = React.useState(Boolean(node.isSelected()));
    React.useEffect(() => {
        inputRef.current?.focus();
    }, []);
    const onChange = React.useCallback(() => {
        const newValue = !node.isSelected();
        setChecked(newValue);
        node.setSelected(newValue);
    }, [node]);
    if (data?.__phantom) {
        return null;
    }
    return (React.createElement("div", { className: "ag-cell-wrapper", role: "presentation" },
        React.createElement("div", { className: "ag-selection-checkbox", role: "presentation", style: { display: 'flex', alignItems: 'center', justifyContent: 'center', width: '100%' } },
            React.createElement("div", { role: "presentation", className: "ag-labeled ag-label-align-right ag-checkbox ag-input-field" },
                React.createElement("div", { className: `ag-wrapper ag-input-wrapper ag-checkbox-input-wrapper ${checked ? 'ag-checked' : ''}`, role: "presentation" },
                    React.createElement("input", { ref: inputRef, checked: checked, onChange: onChange, className: "ag-input-field-input ag-checkbox-input", type: "checkbox", tabIndex: -1, "aria-live": "polite", "aria-relevant": "text", "aria-label": `Press Space to toggle row selection (${checked ? 'checked' : 'unchecked'})` }))))));
}
//# sourceMappingURL=checkbox-cell.js.map