import type { UseComboboxGetItemPropsOptions } from 'downshift';
import React from 'react';
import type { SelectItem } from './select-component';
interface SelectDropDownProps {
    addSelectedItem: (item: SelectItem) => void;
    node?: any;
    createTunnelLinkText?: string;
    focusLookupButton: () => void;
    fullWidth?: boolean;
    getItemProps?: (options: UseComboboxGetItemPropsOptions<SelectItem>) => any;
    hasHelperTextField?: boolean;
    hasHighlightMatchText: boolean;
    hasLookupIcon?: boolean;
    highlightedIndex?: number;
    highlightFirstListItem: () => void;
    highlightLastListItem: () => void;
    inputValue: string;
    isItemSelected: (args: {
        id: string;
        value: string;
    }) => boolean;
    isLinkCreateNewText?: boolean;
    isMultiSelect?: boolean;
    isOpen: boolean;
    items: SelectItem[];
    loading: boolean;
    lookupLinkRef?: React.RefObject<HTMLLinkElement>;
    createTunnelLinkRef?: React.RefObject<HTMLLinkElement>;
    maxHeight?: number;
    menuProps?: any;
    minLookupCharacters?: number;
    onCreateNewItemLinkClick?: () => void;
    onLookupIconClick?: (event: React.MouseEvent<any>) => void;
    removeSelectedItem: (item: SelectItem) => void;
    screenId?: string;
    shouldRenderOptionsAbove?: boolean;
    ulRef?: React.RefObject<HTMLUListElement>;
    variant?: 'plain' | 'carbon';
    inputId?: string;
}
export declare function SelectDropDown({ addSelectedItem, node, createTunnelLinkText, focusLookupButton, fullWidth, getItemProps, hasHelperTextField, hasHighlightMatchText, hasLookupIcon, highlightedIndex, highlightFirstListItem, highlightLastListItem, inputValue, isItemSelected, isLinkCreateNewText, isMultiSelect, isOpen, items, loading, lookupLinkRef, createTunnelLinkRef, maxHeight, menuProps, minLookupCharacters, onCreateNewItemLinkClick, onLookupIconClick, removeSelectedItem, screenId, shouldRenderOptionsAbove, ulRef: externalUlRef, variant, inputId, }: SelectDropDownProps): React.ReactElement;
export {};
//# sourceMappingURL=select-dropdown.d.ts.map