import React from 'react';
import styled from 'styled-components';
import { localize } from '../../../service/i18n-service';
import { Icon } from '../icon/icon-component';
import IconButton from 'carbon-react/esm/components/icon-button';
const StyledIconButton = styled(IconButton).attrs((props) => {
    return {
        tabIndex: props.hidden ? '-1' : '0',
    };
}) `
    ${(props) => (props.hidden ? 'visibility: hidden;' : 'visibility: visible;')}
`;
export const ClearButton = React.memo(props => {
    const { hidden } = props;
    return (React.createElement("div", { className: props.classNameSelectClose },
        React.createElement("span", { className: props.closeIconClassName || '' },
            React.createElement(StyledIconButton, { hidden: hidden, "data-testid": "e-ui-select-close", onAction: () => props.onClearFieldButtonClick(), "aria-label": localize('@sage/xtrem-ui/clear-input-text', 'Clear') },
                React.createElement(Icon, { type: "cross_circle" })))));
});
//# sourceMappingURL=clear-button.js.map