// eslint-disable-next-line import/no-named-default
import { default as CarbonPortrait } from 'carbon-react/esm/components/portrait';
import * as React from 'react';
import { getImageUrlFromValue } from '../field/image/image-utils';
export const getFirstThree = (value) => {
    if (typeof value !== 'string') {
        return undefined;
    }
    const length = value.length < 3 ? value.length : 3;
    return value.substring(0, length).toUpperCase();
};
export const getInitials = (value) => {
    if (typeof value !== 'string') {
        return undefined;
    }
    const match = value
        .replace(/[^0-9a-z\s]/gi, '')
        .split(' ')
        .filter(s => /\S/.test(s));
    return match && match.length > 0 ? match.map(s => s[0]).join('') : value;
};
export function Portrait({ icon, image, shape, size, placeholderValue, placeholderMode, }) {
    return (React.createElement("div", { className: "e-portrait" }, image && image.value ? (React.createElement(CarbonPortrait, { shape: shape || 'square', size: size, src: getImageUrlFromValue(image.value), alt: placeholderValue || '' })) : placeholderMode === 'FirstThree' ? (React.createElement(CarbonPortrait, { size: size, alt: placeholderValue || '', iconType: icon, initials: getFirstThree(placeholderValue) })) : (React.createElement(CarbonPortrait, { size: size, alt: placeholderValue || '', iconType: icon, initials: getInitials(placeholderValue) }))));
}
//# sourceMappingURL=portrait-component.js.map