import * as React from 'react';
import type { OnTelemetryEventFunction, ReduxResponsive } from '../../../redux/state';
import type { ScreenBase } from '../../../service/screen-base';
import type { ValidationResult } from '../../../service/screen-base-definition';
import type { ContextType } from '../../../types';
import type { PodDecoratorProperties } from '../../decorators';
export interface PodProps {
    availableColumns: number;
    baseAttributesDivWrapper: any;
    browser?: ReduxResponsive;
    contextType?: ContextType;
    elementId: string;
    fieldProperties: PodDecoratorProperties<ScreenBase, any>;
    isDisabled: boolean;
    isReadOnly: boolean;
    onBlockClick: () => void;
    onChange?: (bind: string, value: any) => Promise<void>;
    onNewPod: () => void;
    onRemove: () => void;
    onTelemetryEvent?: OnTelemetryEventFunction;
    screenId: string;
    validationErrors?: ValidationResult[];
    value: any;
}
export declare function Pod(props: PodProps): React.ReactElement;
//# sourceMappingURL=pod-component.d.ts.map