import type { ClientNode } from '@sage/xtrem-client';
import * as React from 'react';
import type { ReduxResponsive } from '../../redux/state';
import type { CollectionValue } from '../../service/collection-data-service';
import type { PageArticleItem } from '../../service/layout-service';
import type { ScreenBase } from '../../service/screen-base';
import type { ValidationResult } from '../../service/screen-base-definition';
import type { NodePropertyType } from '../../types';
import { ContextType } from '../../types';
import type { ValueOrCallbackWithFieldValue } from '../../utils/types';
import type { NestedField, NestedFieldTypes } from '../nested-fields';
import type { XtremActionPopoverItem } from './xtrem-action-popover';
import type { FieldKey } from '../types';
import type { Dict } from '@sage/xtrem-shared';
import type { FormattedNodeDetails } from '../../service/metadata-types';
export interface NestedBlockProps {
    actionPopoverItems?: XtremActionPopoverItem[];
    additionalTestId?: string;
    availableColumns: number;
    baseClassName?: string;
    browser?: ReduxResponsive;
    canSelect?: boolean;
    contextNode?: NodePropertyType;
    contextType?: ContextType;
    headerLabel?: NestedField<any, FieldKey.Label>;
    hideValidationSummary?: boolean;
    info?: string;
    isCloseIconDisplayed?: boolean;
    isDisabled?: boolean;
    isHidden?: ValueOrCallbackWithFieldValue<any, boolean>;
    isReadOnly?: boolean;
    isSelected?: boolean;
    isTitleHidden?: ValueOrCallbackWithFieldValue<any, boolean>;
    item: Partial<PageArticleItem>;
    level?: number;
    nestedFields: NestedField<ScreenBase, NestedFieldTypes>[];
    nodeTypes?: Dict<FormattedNodeDetails>;
    noMargin?: boolean;
    onActionPopoverOpen?: () => void;
    onBlockClick?: () => void;
    onBlockRemoved?: () => void;
    onBlockSelectionChange?: (isSelected: boolean) => void;
    onChange?: (bind: string, value: any) => Promise<void>;
    parentElementId: string;
    readOnlyOverride?: (this: ScreenBase, elementId: string) => boolean | void;
    recordValue?: ClientNode;
    screenId: string;
    title?: NestedField<ScreenBase, NestedFieldTypes> | ValueOrCallbackWithFieldValue<any, string>;
    validate?: (columnName: string, value: any) => Promise<ValidationResult[]>;
    validationErrors?: ValidationResult[];
    warning?: string;
}
export interface ConnectedNestedBlockProps extends NestedBlockProps {
    recordId: string;
    value?: CollectionValue;
}
export interface NestedBlockExternalProps extends ConnectedNestedBlockProps {
    screenType: string;
}
export declare class NestedBlock extends React.Component<NestedBlockProps> {
    private readonly onChange;
    private readonly renderField;
    private readonly resolveTitle;
    private readonly getStatusIcon;
    private renderTitle;
    private readonly renderHeader;
    render(): React.ReactNode;
}
export declare const ConnectedNestedBlock: import("react-redux").ConnectedComponent<React.ComponentType<NestedBlockProps>, {
    recordId: string;
    value?: CollectionValue<any> | undefined;
    actionPopoverItems?: XtremActionPopoverItem[] | undefined;
    additionalTestId?: string | undefined;
    availableColumns: number;
    baseClassName?: string | undefined;
    browser?: ReduxResponsive | undefined;
    canSelect?: boolean | undefined;
    contextNode?: NodePropertyType | undefined;
    contextType?: ContextType | undefined;
    headerLabel?: NestedField<any, FieldKey.Label, any, any> | undefined;
    hideValidationSummary?: boolean | undefined;
    info?: string | undefined;
    isCloseIconDisplayed?: boolean | undefined;
    isDisabled?: boolean | undefined;
    isHidden?: ValueOrCallbackWithFieldValue<any, boolean> | undefined;
    isReadOnly?: boolean | undefined;
    isSelected?: boolean | undefined;
    isTitleHidden?: ValueOrCallbackWithFieldValue<any, boolean> | undefined;
    item: Partial<PageArticleItem>;
    level?: number | undefined;
    nestedFields: NestedField<ScreenBase, NestedFieldTypes>[];
    nodeTypes?: Dict<FormattedNodeDetails> | undefined;
    noMargin?: boolean | undefined;
    onActionPopoverOpen?: (() => void) | undefined;
    onBlockClick?: (() => void) | undefined;
    onBlockRemoved?: (() => void) | undefined;
    onBlockSelectionChange?: ((isSelected: boolean) => void) | undefined;
    onChange?: ((bind: string, value: any) => Promise<void>) | undefined;
    parentElementId: string;
    readOnlyOverride?: ((this: ScreenBase, elementId: string) => boolean | void) | undefined;
    recordValue?: ClientNode | undefined;
    screenId: string;
    title?: NestedField<ScreenBase<any, any>, NestedFieldTypes, any, any> | ValueOrCallbackWithFieldValue<any, string> | undefined;
    validate?: ((columnName: string, value: any) => Promise<ValidationResult[]>) | undefined;
    validationErrors?: ValidationResult[] | undefined;
    warning?: string | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
} | {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<React.Component<NestedBlockProps, any, any>> | undefined;
    recordId: string;
    value?: CollectionValue<any> | undefined;
    actionPopoverItems?: XtremActionPopoverItem[] | undefined;
    additionalTestId?: string | undefined;
    availableColumns: number;
    baseClassName?: string | undefined;
    browser?: ReduxResponsive | undefined;
    canSelect?: boolean | undefined;
    contextNode?: NodePropertyType | undefined;
    contextType?: ContextType | undefined;
    headerLabel?: NestedField<any, FieldKey.Label, any, any> | undefined;
    hideValidationSummary?: boolean | undefined;
    info?: string | undefined;
    isCloseIconDisplayed?: boolean | undefined;
    isDisabled?: boolean | undefined;
    isHidden?: ValueOrCallbackWithFieldValue<any, boolean> | undefined;
    isReadOnly?: boolean | undefined;
    isSelected?: boolean | undefined;
    isTitleHidden?: ValueOrCallbackWithFieldValue<any, boolean> | undefined;
    item: Partial<PageArticleItem>;
    level?: number | undefined;
    nestedFields: NestedField<ScreenBase, NestedFieldTypes>[];
    nodeTypes?: Dict<FormattedNodeDetails> | undefined;
    noMargin?: boolean | undefined;
    onActionPopoverOpen?: (() => void) | undefined;
    onBlockClick?: (() => void) | undefined;
    onBlockRemoved?: (() => void) | undefined;
    onBlockSelectionChange?: ((isSelected: boolean) => void) | undefined;
    onChange?: ((bind: string, value: any) => Promise<void>) | undefined;
    parentElementId: string;
    readOnlyOverride?: ((this: ScreenBase, elementId: string) => boolean | void) | undefined;
    recordValue?: ClientNode | undefined;
    screenId: string;
    title?: NestedField<ScreenBase<any, any>, NestedFieldTypes, any, any> | ValueOrCallbackWithFieldValue<any, string> | undefined;
    validate?: ((columnName: string, value: any) => Promise<ValidationResult[]>) | undefined;
    validationErrors?: ValidationResult[] | undefined;
    warning?: string | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=nested-block.d.ts.map