import React from 'react';
import type { PropertyValueType } from '../../field/reference/reference-types';
import type { MobileTableProps } from '../../field/table/mobile-table-component';
import type { CollectionItem } from '../../types';
export interface UiMobileTableProps {
    canDragCard?: boolean;
    elementId: string;
    fieldProperties: MobileTableProps['fieldProperties'];
    groupByField: PropertyValueType;
    hasMorePages: boolean;
    isDisabled: boolean;
    isFetchingNextPage?: boolean;
    isGreaterThanSmall: boolean;
    isLoading?: boolean;
    isNavigationPanel: boolean;
    isUsingInfiniteScroll?: boolean;
    onFetchNextPage: () => void;
    onKeyDown?: (event: React.KeyboardEvent<HTMLDivElement>) => void;
    onResetFilter?: () => void;
    onRowClick?: (item: any) => (_item: any, isModifierKeyPushed: boolean) => void;
    onRowSelected: (row: CollectionItem) => Promise<void>;
    onScroll?: (event: React.SyntheticEvent<HTMLDivElement>) => void;
    screenId: string;
    searchText?: string;
    valuesDisplayed: any[];
    canAddRecord?: boolean;
    isNestedGrid?: boolean;
    dropdownActions?: MobileTableProps['fieldProperties']['dropdownActions'];
    inlineActions?: MobileTableProps['fieldProperties']['inlineActions'];
    columns: MobileTableProps['fieldProperties']['columns'];
}
export declare function MobileTable(props: UiMobileTableProps): JSX.Element;
//# sourceMappingURL=mobile-table-component.d.ts.map