import type { ClientNode, Dict } from '@sage/xtrem-client';
import type { LocalizeLocale } from '@sage/xtrem-shared';
import React from 'react';
import type { FocusPosition, ReduxResponsive } from '../../../redux/state';
import { CollectionValue } from '../../../service/collection-data-service';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenBaseDefinition } from '../../../service/screen-base-definition';
import type { NodePropertyType } from '../../../types';
import type { TableProperties } from '../../field/field-control-objects';
import type { NestedField } from '../../nested-fields';
import type { CollectionItem, PartialCollectionValueWithIds } from '../../types';
import type { DataTypeDetails, FormattedNodeDetails } from '../../../service/metadata-types';
import type { ReferenceDecoratorProperties } from '../../decorator-properties';
export interface LookupDialogExternalProps<T extends ClientNode = any> {
    /** Whether the lookup dialog is open */
    isOpen: boolean;
    isMultiSelect?: boolean;
    contextNode?: NodePropertyType;
    fieldId: string;
    fieldProperties: ReferenceDecoratorProperties<ScreenBase, T>;
    isLinkCreateNewText?: boolean;
    parentElementId?: string;
    recordContext?: Dict<any>;
    screenId: string;
    searchText?: string;
    selectedRecordId?: string | string[];
    valueField?: any;
    closeLookupDialog: () => void;
    onSelectionFinished: (selectedValue?: CollectionItem[]) => void;
    level?: number;
    value?: CollectionValue;
    createTunnelLinkText?: string;
    onCreateNewItemLinkClick?: () => void;
}
export interface LookupDialogProps<T extends ClientNode = any> extends LookupDialogExternalProps<T> {
    browser: ReduxResponsive;
    nodeTypes: Dict<FormattedNodeDetails>;
    enumTypes: Dict<string[]>;
    dataTypes: Dict<DataTypeDetails>;
    onOpenLookupDialog: (dialogDetails: FocusPosition & {
        dialogTitle: string;
        onClose: () => void;
    }) => void;
    onCloseLookupDialog: () => void;
    screenDefinition: ScreenBaseDefinition;
    locale: LocalizeLocale;
}
export interface LookupDialogState {
    value: CollectionValue | null;
    appliedSearchText: string;
    selectedItems: string[];
}
export declare class LookupDialog<T extends ClientNode = any> extends React.Component<LookupDialogProps<T>, LookupDialogState> {
    constructor(props: LookupDialogProps<T>);
    componentDidMount(): Promise<void>;
    componentDidUpdate(prevProps: LookupDialogProps<T>): Promise<void>;
    componentDidCatch(err: Error): void;
    componentWillUnmount(): void;
    onClose: () => void;
    onRowClick: (selected: CollectionItem) => void;
    onFinishSelection: () => void;
    loadTableData: (elementId: string, appliedSearchText?: string) => Promise<CollectionValue | null>;
    setFieldProperties: (_elementId: string, fieldProperties: TableProperties) => void;
    getColumns: () => NestedField<any, any>[];
    onKeyDown: <ElementT extends Element>(event: React.KeyboardEvent<ElementT>) => void;
    getDialogTitle: () => string;
    getTemporaryRecords: () => PartialCollectionValueWithIds<any>[];
    populateDialog(): Promise<void>;
    renderContent(): JSX.Element;
    render(): React.ReactNode;
}
declare const _default: new <T extends ClientNode = any>() => React.Component<LookupDialogExternalProps<T>, LookupDialogState>;
export default _default;
//# sourceMappingURL=lookup-dialog-component.d.ts.map