import CarbonIconButton from 'carbon-react/esm/components/icon-button';
import CarbonIcon from 'carbon-react/esm/components/icon';
import CarbonButton from 'carbon-react/esm/components/button';
import CarbonLink from 'carbon-react/esm/components/link';
import CarbonTooltip from 'carbon-react/esm/components/tooltip';
import React from 'react';
import styled, { keyframes } from 'styled-components';
import { StyledToast, TypeIcon, StyledToastContent } from 'carbon-react/esm/components/toast/toast.style';
import { localize } from '../../../service/i18n-service';
import * as tokens from '@sage/design-tokens/js/base/common';
import { resolveByValue } from '../../../utils/resolve-value-utils';
const fadeIn = keyframes `
  0% {
    opacity: 0;
  }
  100% {
    opacity: 1;
  }
`;
const TriggerButton = styled(CarbonIconButton) `
    &:focus {
        outline: 2px solid ${tokens.colorsSemanticFocus500};
    }
    margin-top: -2px;
    margin-left: 12px;
    margin-right: 4px;
`;
const CloseButton = styled(CarbonIconButton) `
    top: 24px !important;
    right: 12px !important;
`;
const LinkWithCaret = styled(CarbonLink) `
    & button {
        position: relative;
        color: black;
        text-decoration: none;
        padding-right: 6px;
        span {
            padding-left: 16px;
            text-decoration: underline;
            font-family: ${tokens.fontFamiliesDefault};
            font-weight: ${tokens.fontWeights500};
        }
    }
    & button::before {
        position: absolute;
        content: '\\E95F';
        font-family: 'CarbonIcons';
        top: 3px;
    }
`;
const Toast = styled(StyledToast) `
    animation: ${fadeIn} 0.2s linear;
    border: 1px solid var(--colorsSemanticNegative500);
    border-radius: 4px !important;
    max-width: 471px;
    padding-right: 8px;
    margin: 0 !important;
`;
const ToastContent = styled(StyledToastContent) `
    padding: 16px 16px 4px 24px;
`;
const StyledTypeIcon = styled(TypeIcon) `
    z-index: 6001;
`;
class StatusIconWithPopover extends React.Component {
    constructor(props) {
        super(props);
        this.toolTipRef = React.createRef();
        this.triggerButtonRef = React.createRef();
        this.closeButtonRef = React.createRef();
        this.isVisible = () => {
            return false;
        };
        this.getDisplayErrorsButton = () => {
            return this.toolTipRef.current?.querySelector('button.e-button-filter-validation-errors');
        };
        this.close = () => {
            this.setState({ isOpen: false }, () => {
                this.triggerButtonRef.current?.focus();
            });
        };
        this.open = (ev) => {
            ev?.preventDefault();
            this.setState({ isOpen: true }, () => {
                if (this.toolTipRef.current) {
                    this.toolTipRef.current.style.padding = '0';
                }
                const errorButton = this.getDisplayErrorsButton();
                // We need this timeout because if you open the tooltip with the keyboard it will press the focus button too.
                setTimeout(() => {
                    if (errorButton) {
                        errorButton.focus();
                    }
                    else if (this.closeButtonRef.current) {
                        this.closeButtonRef.current.focus();
                    }
                }, 100);
            });
        };
        this.toggle = () => {
            if (!this.isVisible()) {
                this.open();
            }
            else {
                this.close();
            }
        };
        this.setDefaultMode = async () => {
            await this.props.unFilterErrors?.();
            this.setState({ mode: 'DEFAULT' });
        };
        this.setErrorsMode = async () => {
            await this.props.filterErrors?.();
            this.setState({ mode: 'ERRORS' });
            this.close();
        };
        this.getFilterButton = () => {
            if (this.props.filterErrors === undefined && this.props.unFilterErrors === undefined) {
                return null;
            }
            return this.state.mode === 'ERRORS' ? (React.createElement(CarbonButton
            // className="e-button-filter-validation-errors"
            , { 
                // className="e-button-filter-validation-errors"
                buttonType: "secondary", size: "small", onClick: this.setDefaultMode }, localize('@sage/xtrem-ui/display-errors-back-to-full-display', 'Back to full display'))) : (React.createElement(CarbonButton
            // className="e-button-filter-validation-errors"
            , { 
                // className="e-button-filter-validation-errors"
                buttonType: "secondary", size: "small", onClick: this.setErrorsMode }, localize('@sage/xtrem-ui/display-errors-button', 'Display these errors')));
        };
        this.state = { mode: 'DEFAULT', isOpen: false };
    }
    render() {
        const numErrors = this.props.validationErrors?.length || 0;
        const warning = (!numErrors &&
            resolveByValue({
                screenId: this.props.screenId,
                fieldValue: null,
                propertyValue: this.props.warningMessage,
                rowValue: null,
                skipHexFormat: true,
            })) ||
            undefined;
        const info = (!numErrors &&
            !warning &&
            resolveByValue({
                screenId: this.props.screenId,
                fieldValue: null,
                propertyValue: this.props.infoMessage,
                rowValue: null,
                skipHexFormat: true,
            })) ||
            undefined;
        return (React.createElement(React.Fragment, null,
            (numErrors > 0 || info || warning) && (React.createElement("span", null,
                numErrors > 0 && (React.createElement(CarbonTooltip, { ref: this.toolTipRef, position: "right", fontColor: tokens.colorsUtilityYin090, bgColor: tokens.colorsSemanticNegative500, isVisible: this.state.isOpen, message: React.createElement(Toast, { variant: "error" },
                        React.createElement(StyledTypeIcon, { variant: "error" },
                            React.createElement(CarbonIcon, { type: "error" })),
                        React.createElement(ToastContent, null,
                            this.props.content,
                            this.getFilterButton()),
                        React.createElement(CloseButton, { ref: this.closeButtonRef, 
                            // @ts-expect-error className is a valid prop
                            className: "e-button-validation-errors-close", "data-element": "close", onAction: this.close },
                            React.createElement(CarbonIcon, { type: "close" }))) },
                    React.createElement(TriggerButton, { onAction: this.toggle, ref: this.triggerButtonRef },
                        React.createElement(CarbonIcon, { key: "validation-errors", className: "e-icon-validation-errors", "aria-label": "validation-errors", fontSize: "small", color: "--colorsSemanticNegative500", type: "error", role: "tooltip" })))),
                info && (React.createElement(CarbonIcon, { key: "info", className: "e-icon-validation-errors", ariaLabel: info, fontSize: "small", color: tokens.colorsSemanticInfo500, type: "info", role: "tooltip", tooltipMessage: info })),
                warning && (React.createElement(CarbonIcon, { key: "warning", className: "e-icon-validation-errors", ariaLabel: warning, fontSize: "small", color: tokens.colorsSemanticCaution500, type: "warning", role: "tooltip", tooltipMessage: warning })))),
            this.state.mode === 'ERRORS' && (React.createElement(CarbonTooltip, { key: "e-link-back-to-full-display-tooltip", message: localize('@sage/xtrem-ui/display-errors-back-to-full-display-tooltip', 'For full display') },
                React.createElement(LinkWithCaret, { key: "e-link-back-to-full-display", onClick: this.setDefaultMode, className: "e-link-back-to-full-display" }, localize('@sage/xtrem-ui/display-errors-back-to-full-display', 'Back to full display')))),
            this.state.mode === 'DEFAULT' && numErrors > 0 && (React.createElement(CarbonTooltip, { key: "e-link-error-numbers-tooltip", message: localize('@sage/xtrem-ui/link-error-numbers-tooltip', 'Error information') },
                React.createElement(LinkWithCaret, { key: "e-link-error-numbers", onClick: this.open, className: "e-link-error-numbers" }, numErrors > 1
                    ? localize('@sage/xtrem-ui/link-errors-quantity', '{{0}} errors', [numErrors])
                    : localize('@sage/xtrem-ui/link-error-quantity', '1 error', [numErrors]))))));
    }
}
export default StatusIconWithPopover;
//# sourceMappingURL=status-icon-with-popover.js.map