import { FieldKey, GraphQLTypes, aggregationsGraphqlMapping, filterGraphqlMapping } from '@sage/xtrem-shared';
export { FieldKey };
export { GraphQLTypes };
export var ActionKey;
(function (ActionKey) {
    ActionKey["PageAction"] = "PageAction";
})(ActionKey || (ActionKey = {}));
export var ContainerKey;
(function (ContainerKey) {
    ContainerKey["Block"] = "Block";
    ContainerKey["DetailPanel"] = "DetailPanel";
    ContainerKey["GridRowBlock"] = "GridRowBlock";
    ContainerKey["Page"] = "Page";
    ContainerKey["PageFragment"] = "PageFragment";
    ContainerKey["FragmentFields"] = "FragmentFields";
    ContainerKey["Section"] = "Section";
    ContainerKey["Sticker"] = "Sticker";
    ContainerKey["Tile"] = "Tile";
})(ContainerKey || (ContainerKey = {}));
export var TableDisplayMode;
(function (TableDisplayMode) {
    TableDisplayMode["comfortable"] = "comfortable";
    TableDisplayMode["compact"] = "compact";
})(TableDisplayMode || (TableDisplayMode = {}));
export const LESS_THAN = 'lessThan';
export const LESS_THAN_EQUAL = 'lessThanOrEqual';
export const RANGE = 'inRange';
export const MULTIPLE_RANGE = 'multipleRange';
export const GREATER_THAN = 'greaterThan';
export const GREATER_THAN_EQUAL = 'greaterThanOrEqual';
export const CONTAINS = 'contains';
export const STARTS_WITH = 'startsWith';
export const ENDS_WITH = 'endsWith';
export const MATCHES = 'matches';
export const EQUALS = 'equals';
export const NOT_EQUALS = 'notEqual';
export const MULTI_NOT_EQUALS = 'multiNotEqual';
export const SET = 'set';
export const RANGE_DIVIDER = '~';
export const rangeFilter = [
    LESS_THAN,
    LESS_THAN_EQUAL,
    EQUALS,
    NOT_EQUALS,
    GREATER_THAN,
    GREATER_THAN_EQUAL,
    RANGE,
];
export const enumFilter = [SET, MULTI_NOT_EQUALS];
export const filterableGraphqlTypes = Object.entries(filterGraphqlMapping).reduce((acc, [k, v]) => {
    if (v !== undefined) {
        acc.push(k);
    }
    return acc;
}, []);
export const aggregatableGraphqlTypes = Object.entries(aggregationsGraphqlMapping).reduce((acc, [k, v]) => {
    if (v !== undefined) {
        acc.push(k);
    }
    return acc;
}, []);
//# sourceMappingURL=types.js.map