import React from 'react';
import Sidebar from 'carbon-react/esm/components/sidebar';
import { connect } from 'react-redux';
import * as xtremRedux from '../../redux';
import { ConnectedTableSidebarBody } from './table-sidebar-body';
import DialogFullScreen from 'carbon-react/esm/components/dialog-full-screen';
import { ConnectedTableSidebarFooter } from './table-sidebar-footer';
import { ConnectedTableSidebarHeader } from './table-sidebar-header';
import Loader from 'carbon-react/esm/components/loader';
export function TableSidebar({ elementId, isFullWidthDialogScreen, isLoading, isScreenMounted, onCancel, screenId, }) {
    const isOpen = React.useMemo(() => !!screenId && !!elementId, [screenId, elementId]);
    const body = React.useMemo(() => (React.createElement("div", { className: "e-dialog-body" },
        React.createElement("div", { "data-testid": "e-table-sidebar", className: "e-table-sidebar" },
            isOpen && isLoading && React.createElement(Loader, { mt: "24px" }),
            isOpen && !isLoading && React.createElement(ConnectedTableSidebarBody, null),
            isOpen && !isLoading && React.createElement(ConnectedTableSidebarFooter, null)))), [isLoading, isOpen]);
    const dialogProps = React.useMemo(() => ({
        open: isOpen,
        onCancel,
    }), [isOpen, onCancel]);
    if (!isScreenMounted) {
        return null;
    }
    if (isFullWidthDialogScreen) {
        return (React.createElement(DialogFullScreen, { ...dialogProps, title: React.createElement(ConnectedTableSidebarHeader, null) }, body));
    }
    return (React.createElement(Sidebar, { "aria-label": "sidebar", width: 714, ...dialogProps, header: React.createElement(ConnectedTableSidebarHeader, null) }, body));
}
export const mapStateToProps = (state) => {
    return {
        isScreenMounted: !!state.sidebar?.screenId && !!state.screenDefinitions[state.sidebar?.screenId],
        isLoading: state.sidebar?.isLoading,
        screenId: state.sidebar?.screenId,
        elementId: state.sidebar?.elementId,
        isFullWidthDialogScreen: state.browser.is.xs,
    };
};
export const mapDispatchToProps = (dispatch) => {
    return {
        onCancel: () => {
            dispatch(xtremRedux.actions.closeTableSidebar());
        },
    };
};
export const ConnectedTableSidebar = connect(mapStateToProps, mapDispatchToProps)(TableSidebar);
//# sourceMappingURL=table-sidebar.js.map