import type { ClientNode, Dict } from '@sage/xtrem-client';
import type { ScreenExtension } from '../../types';
import type { ValueOrCallback } from '../../utils/types';
import type { MenuSeparatorType } from '../container/page/page-types';
import type { PropertyValueType } from '../field/reference/reference-types';
import type { CollectionItemAction, CollectionItemActionGroup } from '../ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
import type { FieldControlObjectInstance, FieldKey } from '../types';
export interface SidebarFieldBinding {
    fieldId: string;
    isNested: boolean;
}
export type SidebarFieldDefinition<ReferencedItemType extends ClientNode = any> = PropertyValueType<ReferencedItemType> | FieldControlObjectInstance<FieldKey>;
export interface SidebarBlockDefinition<CT extends ScreenExtension<CT> = any, ReferencedItemType extends ClientNode = any> {
    title?: string;
    fields: SidebarFieldDefinition<ReferencedItemType>[];
    isHidden?: (this: CT, _id: string, recordValue?: ReferencedItemType) => boolean;
}
export interface SidebarSectionDefinition<CT extends ScreenExtension<CT> = any, ReferencedItemType extends ClientNode = any> {
    title: string;
    blocks: Dict<SidebarBlockDefinition<CT, ReferencedItemType>>;
    isHidden?: (this: CT, _id: string, recordValue?: ReferencedItemType) => boolean;
}
export interface SidebarDefinitionDecorator<CT extends ScreenExtension<CT> = any, ReferencedItemType extends ClientNode = any> {
    title?: string | ((this: CT, _id: string, recordValue?: ReferencedItemType) => string);
    isReadOnly?: (this: CT, _id: string, recordValue?: ReferencedItemType) => boolean;
    onRecordOpened?: (this: CT, _id: string, recordValue?: ReferencedItemType) => Promise<void>;
    onRecordConfirmed?: (this: CT, _id: string, recordValue?: ReferencedItemType) => Promise<void>;
    onRecordDiscarded?: (this: CT, _id: string, recordValue?: ReferencedItemType) => Promise<void>;
    layout: ValueOrCallback<CT, Dict<SidebarSectionDefinition<CT, ReferencedItemType>>>;
    headerDropdownActions?: Array<CollectionItemAction<CT, ReferencedItemType> | CollectionItemActionGroup<CT, ReferencedItemType> | MenuSeparatorType>;
    headerQuickActions?: Array<CollectionItemAction<CT, ReferencedItemType>>;
}
//# sourceMappingURL=table-sidebar-types.d.ts.map