import { connect } from 'react-redux';
import { getPageDefinitionFromState } from '../../utils/state-utils';
import React from 'react';
import { ContextType } from '../../types';
import ConnectedFieldWrapper from '../../render/field-wrapper';
export function TableSidebarNormalField({ fieldProperties, availableColumns, fieldId, screenId, }) {
    return (React.createElement(ConnectedFieldWrapper, { screenId: screenId, item: { $bind: fieldId, $isFullWidth: fieldProperties.isFullWidth }, availableColumns: availableColumns, contextType: ContextType.sidebar }));
}
export const mapStateToProps = (state, props) => {
    let screenId;
    let fieldProperties;
    if (state.sidebar) {
        screenId = state.sidebar.screenId;
        const pageDefinition = getPageDefinitionFromState(screenId, state);
        fieldProperties = pageDefinition.metadata.uiComponentProperties[props.fieldId];
    }
    return {
        ...props,
        screenId,
        fieldProperties,
    };
};
export const ConnectedTableSidebarNormalField = connect(mapStateToProps)(TableSidebarNormalField);
//# sourceMappingURL=table-sidebar-normal-field.js.map