import { connect } from 'react-redux';
import { getPageDefinitionFromState } from '../../utils/state-utils';
import React from 'react';
import { withCollectionValueItemSubscription } from '../connected-collection';
import { CardComponent } from '../ui/card/card-component';
export function TableSidebarCard({ cardDefinition, screenId, elementId, recordValue, }) {
    if (!cardDefinition) {
        return null;
    }
    return (React.createElement(CardComponent, { canDrag: false, canSelect: false, cardDefinition: cardDefinition, isDisabled: false, isNewItem: false, isSelected: false, parentElementId: elementId, screenId: screenId, value: recordValue }));
}
export const mapStateToProps = (state) => {
    let tableProperties;
    let value;
    if (state.sidebar?.screenId) {
        const pageDefinition = getPageDefinitionFromState(state.sidebar.screenId, state);
        tableProperties = pageDefinition.metadata.uiComponentProperties[state.sidebar.elementId];
        value = pageDefinition.values[state.sidebar.elementId];
    }
    return {
        cardDefinition: tableProperties?.mobileCard,
        recordId: state.sidebar?.recordId || undefined,
        elementId: state.sidebar?.elementId,
        level: state.sidebar?.level,
        screenId: state.sidebar?.screenId,
        value,
        isUncommitted: true,
    };
};
export const ConnectedTableSidebarCard = connect(mapStateToProps)(withCollectionValueItemSubscription(TableSidebarCard));
//# sourceMappingURL=table-sidebar-card.js.map