import { connect } from 'react-redux';
import { getSidebarLayoutDefinitionFromState } from '../../utils/state-utils';
import React from 'react';
import Typography from 'carbon-react/esm/components/typography';
import { calculateContainerWidth, getGutterSize } from '../../utils/responsive-utils';
import { GridRow } from '@sage/xtrem-ui-components';
import { AbstractUiControlObject } from '../abstract-ui-control-object';
import { convertDeepBindToPathNotNull } from '../../utils/nested-field-utils';
import { ConnectedTableSidebarNestedField } from './table-sidebar-nested-field';
import { ConnectedTableSidebarNormalField } from './table-sidebar-normal-field';
import { getCustomFields } from '../../service/customization-service';
import { FieldKey } from '../types';
import { mergeIntoSidebarLayout } from '../abstract-decorator-utils';
const COLUMN_COUNT = 4;
export function TableSidebarBlock({ title, browser, fields, screenId }) {
    const computedWidth = calculateContainerWidth(browser.is, COLUMN_COUNT, 'extra-large');
    const gridGutter = getGutterSize(browser.is);
    return (React.createElement("div", { className: "e-table-sidebar-block" },
        title && (React.createElement(Typography, { variant: "h4", mb: "8px" }, title)),
        React.createElement(GridRow, { columns: computedWidth, gutter: gridGutter, margin: 0, verticalMargin: 0 }, fields.map(f => f.isNested ? (React.createElement(ConnectedTableSidebarNestedField, { ...f, screenId: screenId, key: `${convertDeepBindToPathNotNull(f.fieldId)}-${f.isNested ? 'nested' : 'main'}}`, availableColumns: COLUMN_COUNT })) : (React.createElement(ConnectedTableSidebarNormalField, { screenId: screenId, key: `${convertDeepBindToPathNotNull(f.fieldId)}-${f.isNested ? 'nested' : 'main'}}`, availableColumns: COLUMN_COUNT, fieldId: f.fieldId }))))));
}
export const mapStateToProps = (state, props) => {
    const level = state.sidebar?.level ?? 0;
    let sidebarLayoutDefinition = getSidebarLayoutDefinitionFromState(state);
    if (state.sidebar?.screenId && state.sidebar?.elementId && state.sidebar?.recordId) {
        const screenDefinition = state.screenDefinitions[state.sidebar.screenId];
        const value = screenDefinition.values[state.sidebar.elementId];
        const customFields = getCustomFields(String(value.contextNode || value.nodes[level]), state.nodeTypes, value.getColumnDefinitions(level), state.sidebar?.elementId, FieldKey.Table, screenDefinition.metadata.customizations);
        sidebarLayoutDefinition = mergeIntoSidebarLayout(sidebarLayoutDefinition, customFields);
    }
    const fields = sidebarLayoutDefinition[props.section].blocks[props.block].fields.map(f => {
        if (f instanceof AbstractUiControlObject) {
            return {
                isNested: false,
                fieldId: f.id,
            };
        }
        return {
            fieldId: convertDeepBindToPathNotNull(f),
            isNested: true,
        };
    });
    return {
        ...props,
        screenId: state.sidebar?.screenId || '',
        browser: state.browser,
        fields,
        title: sidebarLayoutDefinition[props.section].blocks[props.block].title,
    };
};
export const ConnectedTableSidebarBlock = connect(mapStateToProps)(TableSidebarBlock);
//# sourceMappingURL=table-sidebar-block.js.map