import { resolveByValue } from '../../utils/resolve-value-utils';
export const FieldControlObjectResolvedProperty = (hooks) => (controlObjectConstructor, name) => {
    Object.defineProperty(controlObjectConstructor, name, {
        get() {
            if (hooks?.onGet) {
                hooks.onGet.apply(this, [this.screenId, this.elementId]);
            }
            return resolveByValue({
                fieldValue: this.value,
                propertyValue: this.getUiComponentProperty(name),
                skipHexFormat: true,
                screenId: this.screenId,
                rowValue: null, // The decorators are not used in nested context directly, therefore it's fine to pass null as the row value
            });
        },
        set(value) {
            if (hooks?.onSet) {
                hooks.onSet.apply(this, [this.screenId, this.elementId, value]);
            }
            this.setUiComponentProperties(name, value);
        },
        enumerable: true,
        configurable: true,
    });
};
export const ContainerControlObjectResolvedProperty = () => (controlObjectConstructor, name) => {
    Object.defineProperty(controlObjectConstructor, name, {
        get() {
            return resolveByValue({
                propertyValue: this.getUiComponentProperty(name),
                skipHexFormat: true,
                screenId: this.screenId,
                rowValue: null, // The decorators are not used in nested context directly, therefore it's fine to pass null as the row value
            });
        },
        set(value) {
            this.setUiComponentProperties(name, value);
        },
        enumerable: true,
        configurable: true,
    });
};
//# sourceMappingURL=control-object-resolved-property-decorator.js.map