/**
 * @packageDocumentation
 * @module root
 * */
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { ScreenBase } from '../../service/screen-base';
import type { ScreenExtension } from '../../types';
import type { ValueOrCallbackWithFieldValue } from '../../utils/types';
import type { UiComponentProperties } from '../abstract-ui-control-object';
import { AbstractUiControlObject } from '../abstract-ui-control-object';
import type { Clickable, HasHelperText, HasIcon, HasShortcuts } from '../field/traits';
import type { ButtonProps } from 'carbon-react/esm/components/button';
export type PageActionButtonType = ButtonProps['buttonType'];
export interface PageActionProperties<CT extends ScreenBase = ScreenBase> extends UiComponentProperties<CT>, HasHelperText, Clickable<CT>, HasIcon, HasShortcuts {
    /** Type of button, according with Carbon's API. Can be primary, secondary or tertiary */
    buttonType?: PageActionButtonType;
    /** Whether the HTML element is hidden or not. Defaults to false */
    isHidden?: ValueOrCallbackWithFieldValue<CT, boolean>;
    /** If set, only the icon is displayed, the title is used as a tooltip */
    isIconButton?: boolean;
    /** If set the action's icon and text are rendered in red. Optional, defaults to false. */
    isDestructive?: boolean;
}
export interface IPageAction<CT extends ScreenExtension<CT> = ScreenBase> {
    screenId: string;
    elementId: string;
    getUiComponentProperties?: (screenId: string, elementId: string) => PageActionProperties<CT>;
    setUiComponentProperties?: (screenId: string, elementId: string, state: PageActionProperties<CT>) => void;
}
/**
 * Action that will be placed in the page header (i.e. business action)
 */
export declare class PageActionControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends AbstractUiControlObject<CT, PageActionProperties<CT>> {
    static readonly defaultUiProperties: Partial<PageActionProperties<any>>;
    constructor({ screenId, elementId, getUiComponentProperties, setUiComponentProperties, }: IPageAction<CT>);
    /** Additional text that will be displayed when mousing over the page action */
    helperText?: string;
    /** Icon of the action */
    icon?: IconType;
    /** Whether the action is displayed */
    isHidden?: boolean;
    /** Whether the action is displayed */
    buttonType?: PageActionButtonType;
    execute(executeErrorHandlers?: boolean, ...args: any[]): Promise<void>;
}
//# sourceMappingURL=page-action-control-object.d.ts.map