import { SelectionCard } from '@sage/xtrem-ui-components';
import * as React from 'react';
import { resolveDetailedIcon } from '../../../utils/detailed-icons-utils';
import { useSelector } from 'react-redux';
export function WorkflowNodeSelectorComponent({ value, onChange, filterType, }) {
    const workflowNodes = useSelector(s => s.workflowNodes);
    if (!workflowNodes) {
        return null;
    }
    return (React.createElement("div", { className: "selection-card-container" }, workflowNodes
        .filter(n => !filterType || filterType.indexOf(n.type) !== -1)
        .sort((a, b) => a.title.localeCompare(b.title))
        .map(n => {
        return (React.createElement(SelectionCard, { key: n.key, _id: n.key, isSelected: value === n.key, title: n.title, icon: resolveDetailedIcon(n.icon), description: n.description, onClick: () => onChange(n.key) }));
    })));
}
//# sourceMappingURL=workflow-node-selector-component.js.map