/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { WorkflowControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class WorkflowDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = WorkflowControlObject;
    }
}
/**
 * Initializes the decorated member as a [FormDesigner]{@link WorkflowControlObject} field with the provided properties
 *
 * @param properties The properties that the [FormDesigner]{@link WorkflowControlObject} field will be initialized with
 */
export function workflowField(properties) {
    return standardDecoratorImplementation(properties, WorkflowDecorator, FieldKey.Workflow, true);
}
export function workflowFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=workflow-decorator.js.map