/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { WorkflowDecoratorProperties, WorkflowExtensionDecoratorProperties } from './workflow-types';
/**
 * Initializes the decorated member as a [FormDesigner]{@link WorkflowControlObject} field with the provided properties
 *
 * @param properties The properties that the [FormDesigner]{@link WorkflowControlObject} field will be initialized with
 */
export declare function workflowField<CT extends ScreenExtension<CT>>(properties: WorkflowDecoratorProperties<Extend<CT>>): (target: CT, name: string) => void;
export declare function workflowFieldOverride<CT extends ScreenExtension<CT>>(properties: WorkflowExtensionDecoratorProperties<CT>): (target: CT, name: string) => void;
//# sourceMappingURL=workflow-decorator.d.ts.map