/* eslint-disable @typescript-eslint/no-loop-func */
import { MarkerType } from 'reactflow';
import { useFieldValue } from '../../../utils/hooks/effects/use-set-field-value';
import { triggerFieldEvent } from '../../../utils/events';
import * as tokens from '@sage/design-tokens/js/base/common';
import { remove } from 'lodash';
export const edgeStyle = {
    style: {
        strokeWidth: 2,
        stroke: tokens.colorsYin090,
    },
    markerEnd: {
        type: MarkerType.ArrowClosed,
        width: 12,
        height: 12,
        color: tokens.colorsYin090,
    },
};
export const removeTransientNodeDataProperties = (data) => {
    const cleanData = { ...data };
    delete cleanData.type;
    return cleanData;
};
export const removeTransientNodeDataPropertiesFromNodes = (nodes) => nodes.map(n => ({ ...n, selected: false, data: removeTransientNodeDataProperties(n.data) }));
export const removeTransientEdgeDataPropertiesFromEdges = (nodes) => nodes.map(e => {
    const edgeCopy = { ...e };
    delete edgeCopy.markerEnd;
    delete edgeCopy.data;
    delete edgeCopy.style;
    return edgeCopy;
});
export const changeEventHandler = (screenId, elementId) => () => triggerFieldEvent(screenId, elementId, 'onChange');
export const usePreviousWorkflowNodes = (nodeId, screenId, elementId, includeCurrent = false) => {
    const fieldValue = useFieldValue(screenId, elementId);
    if (!fieldValue || !nodeId) {
        return [];
    }
    const currentNode = fieldValue.nodes.find(n => n.id === nodeId);
    let currentNodeId = nodeId;
    const previousNodes = includeCurrent && currentNode ? [currentNode] : [];
    // eslint-disable-next-line no-constant-condition
    while (true) {
        currentNodeId = fieldValue.edges.find(e => e.target === currentNodeId)?.source;
        if (!currentNodeId) {
            break;
        }
        const node = fieldValue.nodes.find(n => n.id === currentNodeId);
        if (!node) {
            break;
        }
        previousNodes.push(node);
    }
    return previousNodes.reverse();
};
export const useSourceNode = (edgeId, screenId, elementId) => {
    const fieldValue = useFieldValue(screenId, elementId);
    if (!fieldValue) {
        return null;
    }
    const edge = fieldValue?.edges.find(e => e.id === edgeId);
    if (!edge) {
        return null;
    }
    return fieldValue.nodes.find(n => n.id === edge.source) || null;
};
export const useWorkflowNodeVariables = (nodeId, screenId, elementId, includeCurrent = false) => {
    const previousNodes = usePreviousWorkflowNodes(nodeId, screenId, elementId, includeCurrent);
    return removeTransientNodeDataPropertiesFromNodes(previousNodes).reduce((prevValue, node) => {
        if (node.data.outputVariables) {
            return [...prevValue, ...node.data.outputVariables];
        }
        return prevValue;
    }, []);
};
export function removeChildNodesAndEdgesFromStartPoint(nodeId, tempEdges, tempNodes) {
    remove(tempNodes, n => n.id === nodeId);
    const connectingEdges = tempEdges.filter(e => e.source === nodeId);
    // eslint-disable-next-line no-restricted-syntax
    for (const edge of connectingEdges) {
        const targetNode = tempNodes.find(n => n.id === edge.target);
        const edgesToTarget = tempEdges.filter(e => e.target === edge.target);
        if (edgesToTarget.length === 1 && targetNode) {
            removeChildNodesAndEdgesFromStartPoint(edge.target, tempEdges, tempNodes);
        }
        else {
            remove(tempEdges, e => e.id === edge.id);
        }
    }
}
export function allocateId(prefix, items) {
    for (let i = 1; i < 1000; i += 1) {
        const id = `${prefix}-${i}`;
        if (!items.find(n => n.id === id))
            return id;
    }
    throw new Error('Could not find a unique id');
}
//# sourceMappingURL=workflow-component-utils.js.map