import { Handle, Position } from 'reactflow';
import * as React from 'react';
import { useSelector } from 'react-redux';
import Icon from 'carbon-react/esm/components/icon';
import IconButton from 'carbon-react/esm/components/icon-button';
import { openPageDialog } from '../../../service/dialog-service';
import { removeTransientNodeDataProperties, useWorkflowNodeVariables } from './workflow-component-utils';
import { resolveDetailedIcon } from '../../../utils/detailed-icons-utils';
import { WorkflowContext } from './workflow-context-provider';
export function CustomNode({ data, isConnectable, id }) {
    const context = React.useContext(WorkflowContext);
    const inputVariables = useWorkflowNodeVariables(id, context?.screenId, context?.elementId);
    const workflowNodeType = useSelector(s => s.workflowNodes?.find(n => n.key === data.type) || null);
    const onConfigurationOpen = React.useCallback(async () => {
        if (!workflowNodeType?.configurationPage || !context?.onNodeDataChange) {
            return;
        }
        try {
            const result = await openPageDialog(workflowNodeType.configurationPage, { inputVariables: inputVariables }, { values: removeTransientNodeDataProperties(data), size: 'extra-large' });
            context.onNodeDataChange(id, { ...result, type: data.type });
        }
        catch (e) {
            // intentionally left empty
        }
    }, [workflowNodeType?.configurationPage, inputVariables, data, context, id]);
    if (!workflowNodeType) {
        return null;
    }
    return (React.createElement("div", { className: `e-workflow-node e-workflow-node-${workflowNodeType.type} e-workflow-node-${workflowNodeType.key}`, "data-testid": `e-workflow-node e-workflow-node-${workflowNodeType.type} e-workflow-node-${workflowNodeType.key}`, "data-nodeid": id, style: { borderColor: workflowNodeType.color } },
        workflowNodeType.type !== 'condition' && (React.createElement("div", { className: "e-workflow-node-icon", style: {
                mask: `url(${resolveDetailedIcon(workflowNodeType.icon)}) no-repeat left center`,
                maskSize: '32px 32px',
                backgroundColor: workflowNodeType.color,
            } })),
        React.createElement("div", { className: `e-workflow-node-body e-workflow-node-${workflowNodeType.type}-body` },
            React.createElement("div", { className: "e-workflow-node-title" },
                React.createElement("div", { className: "e-workflow-node-title-label" }, data.title || workflowNodeType.title),
                workflowNodeType.configurationPage && !context?.isReadOnly && (React.createElement(IconButton, { onClick: onConfigurationOpen },
                    React.createElement(Icon, { ml: workflowNodeType.type !== 'condition' ? '8px' : undefined, type: "edit", color: workflowNodeType.type === 'condition'
                            ? '--colorsUtilityYang100'
                            : '--colorsUtilityYin090' })))),
            data.subtitle && React.createElement("div", { className: "e-workflow-node-subtitle" }, data.subtitle),
            data.details && React.createElement("div", { className: "e-workflow-node-details" }, data.details)),
        workflowNodeType.type !== 'event' && (React.createElement(Handle, { type: "target", position: Position.Top, id: "in", isConnectable: isConnectable })),
        workflowNodeType.type === 'condition' && (React.createElement(Handle, { type: "source", position: Position.Right, id: "out-false", isConnectable: isConnectable })),
        React.createElement(Handle, { type: "source", position: Position.Bottom, id: workflowNodeType.type === 'condition' ? 'out-true' : 'out', isConnectable: isConnectable })));
}
//# sourceMappingURL=custom-node.js.map