import React from 'react';
import { getBezierPath, EdgeLabelRenderer, BaseEdge } from 'reactflow';
import { useSourceNode } from './workflow-component-utils';
import Icon from 'carbon-react/esm/components/icon';
import { localize } from '../../../service/i18n-service';
// this is a little helper component to render the actual edge label
function ConditionEdgeLabel({ sourceX, sourceY, sourceHandleId, }) {
    const isTruePath = sourceHandleId === 'out-true';
    return (React.createElement("div", { style: {
            position: 'absolute',
            background: 'transparent',
            padding: 10,
            color: '#ff5050',
            fontSize: 12,
            fontWeight: 700,
            transform: `translate(-50%, 0%) translate(${sourceX}px,${sourceY}px)`,
        }, className: "nodrag nopan" },
        React.createElement(Icon, { tooltipMessage: isTruePath
                ? localize('@sage/xtrem-ui/workflow-component-edge-true-path', 'Path for true condition')
                : localize('@sage/xtrem-ui/workflow-component-edge-false-path', 'Path for false condition'), type: isTruePath ? 'tick' : 'cross', color: "--colorsUtilityYin090" })));
}
export function CustomEdge({ id, sourceX, sourceY, targetX, targetY, sourcePosition, targetPosition, sourceHandleId, data, markerEnd, style, }) {
    const sourceNode = useSourceNode(id, data?.screenId, data?.elementId);
    const [edgePath] = getBezierPath({
        sourceX,
        sourceY,
        sourcePosition,
        targetX,
        targetY,
        targetPosition,
    });
    return (React.createElement(React.Fragment, null,
        React.createElement(BaseEdge, { id: id, path: edgePath, markerEnd: markerEnd, style: style }),
        React.createElement(EdgeLabelRenderer, null,
            sourceNode?.type === 'condition' && sourceHandleId === 'out-true' && (React.createElement(ConditionEdgeLabel, { sourceHandleId: sourceHandleId, sourceX: sourceX, sourceY: sourceY })),
            sourceNode?.type === 'condition' && sourceHandleId === 'out-false' && (React.createElement(ConditionEdgeLabel, { sourceHandleId: sourceHandleId, sourceX: sourceX, sourceY: sourceY })))));
}
//# sourceMappingURL=custom-edge.js.map