import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { VitalPodControlObject } from './vital-pod-control-object';
class VitalPodDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = VitalPodControlObject;
    }
}
/**
 * Initializes the decorated member as a [VitalPod]{@link VitalPodControlObject} field with the provided properties.
 *
 * @param properties The properties that the [VitalPod]{@link VitalPodControlObject} field will be initialized with.
 */
export function vitalPodField(properties) {
    return standardDecoratorImplementation(properties, VitalPodDecorator, FieldKey.VitalPod);
}
export function vitalPodFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=vital-pod-decorator.js.map