import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedVitalPodComponent = React.lazy(() => import('./vital-pod-component'));
export function AsyncConnectedVitalPodComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "200px" }) },
        React.createElement(ConnectedVitalPodComponent, { ...props })));
}
const VitalPodComponent = React.lazy(() => import('./vital-pod-component').then(e => ({ default: e.VitalPodComponent })));
export function AsyncVitalPodComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: false, bodyHeight: "200px" }) },
        React.createElement(VitalPodComponent, { ...props })));
}
//# sourceMappingURL=async-vital-pod-component.js.map