/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { VisualProcessControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class VisualProcessDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = VisualProcessControlObject;
    }
}
/**
 * Initializes the decorated member as a [VisualProcess]{@link VisualProcessControlObject} field with the provided properties
 *
 * @param properties The properties that the [VisualProcess]{@link VisualProcessControlObject} field will be initialized with
 */
export function visualProcessField(properties) {
    return standardDecoratorImplementation(properties, VisualProcessDecorator, FieldKey.VisualProcess);
}
export function visualProcessFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=visual-process-decorator.js.map