import type { ConsumerDataRequestResult } from '@sage/visual-process-editor';
import * as React from 'react';
import type { VisualProcessProperties } from '../../control-objects';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { CollectionValue } from '../../../service/collection-data-service';
export interface VisualProcessComponentState {
    lookupDialogPageResultCallback?: (result: ConsumerDataRequestResult) => void;
    lookupDialogPageValue?: CollectionValue;
}
export declare class VisualProcessComponent extends EditableFieldBaseComponent<VisualProcessProperties, {
    value: string;
}, {}, VisualProcessComponentState> {
    private readonly onChange;
    private readonly onLinkClick;
    private readonly onGetData;
    private readonly onPageLookupDialogSelected;
    readonly closeLookupDialog: () => void;
    render(): React.ReactNode;
}
export declare const ConnectedVisualProcessComponent: import("react-redux").ConnectedComponent<typeof VisualProcessComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<VisualProcessComponent> | undefined;
    contextType?: import("../../../types").ContextType | undefined;
    fixedHeight?: number | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    bind?: any;
    elementId: string;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    parentElementId?: string | undefined;
    level?: number | undefined;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    recordContext?: any;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedVisualProcessComponent;
//# sourceMappingURL=visual-process-component.d.ts.map