/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { TreeControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
import { count } from '../../nested-fields';
class TreeDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = TreeControlObject;
    }
}
/**
 * Initializes the decorated member as a [Tree]{@link TreeControlObject} field with the provided properties
 *
 * @param properties The properties that the [Tree]{@link TreeControlObject} field will be initialized with
 */
export function treeField(properties) {
    const propertiesCopy = {
        columns: [],
        ...properties,
    };
    // Add master column as hidden column
    propertiesCopy.columns.push({
        ...properties.masterColumn,
        properties: { ...properties.masterColumn.properties, isHidden: true },
        defaultUiProperties: { ...properties.masterColumn.properties, isHidden: true },
    });
    // Add aggregate column for the total count so we can determine if a row can be extended or not
    propertiesCopy.columns.push(count({ bind: properties.sublevelProperty, isHidden: true }));
    return standardDecoratorImplementation(propertiesCopy, TreeDecorator, FieldKey.Tree, true);
}
//# sourceMappingURL=tree-decorator.js.map