import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedTreeComponent = React.lazy(() => import('./tree-component'));
export function AsyncConnectedTreeComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "200px" }) },
        React.createElement(ConnectedTreeComponent, { ...props })));
}
const TreeComponent = React.lazy(() => import('./tree-component').then(e => ({ default: e.TreeComponent })));
export function AsyncTreeComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: false, bodyHeight: "200px" }) },
        React.createElement(TreeComponent, { ...props })));
}
//# sourceMappingURL=async-tree-component.js.map