import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedToggleComponent = React.lazy(() => import('./toggle-component'));
export function AsyncConnectedToggleComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "80px" }) },
        React.createElement(ConnectedToggleComponent, { ...props })));
}
const ToggleComponent = React.lazy(() => import('./toggle-component').then(c => ({ default: c.ToggleComponent })));
export function AsyncToggleComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(ToggleComponent, { ...props })));
}
//# sourceMappingURL=async-toggle-component.js.map