/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { TimeDecoratorProperties, TimeExtensionDecoratorProperties } from './time-types';
/**
 * Initializes the decorated member as a [Time]{@link TimeControlObject} field with the provided properties.
 *
 * @param properties The properties that the [Time]{@link TimeControlObject} field will be initialized with.
 */
export declare function timeField<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: TimeDecoratorProperties<Extend<T>, ReferencedItemType>): (target: T, name: string) => void;
export declare function timeFieldOverride<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: TimeExtensionDecoratorProperties<T, ReferencedItemType>): (target: T, name: string) => void;
//# sourceMappingURL=time-decorator.d.ts.map