import type { BaseErrorableComponentProperties, NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { Changeable, Clickable, ExtensionField, HasInputValueChangeListener, HasParent, Nested, NestedChangeable, NestedClickable, NestedValidatable, Validatable, HasIcon, HasPlaceholder, Postfixable, Prefixable, Sizable, HasMaxMinLength, NestedGroupAggregations } from '../traits';
import type { BlockControlObject, TileControlObject } from '../../control-objects';
import type { ClientNode } from '@sage/xtrem-client';
import type { ScreenBase } from '../../../service/screen-base';
import type { ValueOrCallbackWitRecordValue } from '../../../utils/types';
import type { FieldControlObjectInstance } from '../../types';
import type { EditableFieldProperties } from '../../editable-field-control-object';
export interface TextProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT>, HasIcon, HasPlaceholder, Postfixable<CT>, Prefixable<CT>, HasMaxMinLength<CT>, Sizable {
    /** Set text field to be password */
    isPassword?: boolean;
}
export interface TextDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<TextProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, HasParent<CT, BlockControlObject<CT> | TileControlObject<CT>>, HasInputValueChangeListener<CT>, Sizable, ExtensionField<CT, FieldControlObjectInstance<any>>, Validatable<CT, string> {
}
export interface NestedTextProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<TextProperties<CT>, 'bind'>, NestedChangeable<CT>, NestedClickable<CT>, NestedGroupAggregations<'min' | 'max' | 'distinctCount'>, Nested<ContextNodeType>, Sizable, NestedValidatable<CT, string, ContextNodeType> {
    isTableReadOnly?: boolean;
    /** The maximum length of the text field value */
    maxLength?: ValueOrCallbackWitRecordValue<CT, number, ContextNodeType>;
    /** The minimum length of the text field value */
    minLength?: ValueOrCallbackWitRecordValue<CT, number, ContextNodeType>;
}
export type TextComponentProps = BaseErrorableComponentProperties<TextProperties, string, NestedFieldsAdditionalProperties>;
//# sourceMappingURL=text-types.d.ts.map