import { addDisabledToProperties, addMaxLengthToProperties } from '../../../utils/data-type-utils';
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { TextControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class TextDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = TextControlObject;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addMaxLengthToProperties({ dataType, propertyDetails, properties });
        addDisabledToProperties({
            propertyDetails,
            dataType,
            properties,
        });
        return properties;
    }
}
/**
 * Initializes the decorated member as a [Text]{@link TextControlObject} field with the provided properties
 *
 * @param properties The properties that the [Text]{@link TextControlObject} field will be initialized with
 */
export function textField(properties) {
    return standardDecoratorImplementation(properties, TextDecorator, FieldKey.Text);
}
export function textFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=text-decorator.js.map