import * as React from 'react';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { TextDecoratorProperties } from './text-types';
type TextComponentProps = BaseEditableComponentProperties<TextDecoratorProperties, string, NestedFieldsAdditionalProperties & {
    isDirty?: boolean;
}>;
export interface TextComponentState {
    value: string;
    isDirty: boolean;
}
export declare class TextComponent extends EditableFieldBaseComponent<TextDecoratorProperties, string, NestedFieldsAdditionalProperties, TextComponentState> {
    constructor(props: TextComponentProps);
    private readonly onInputValueChanged;
    private readonly onChange;
    private readonly onBlur;
    private readonly onKeyDown;
    private readonly onKeyUp;
    private readonly onClick;
    UNSAFE_componentWillReceiveProps(nextProps: TextComponentProps): void;
    private readonly handleFocus;
    private readonly handleSelection;
    render(): React.ReactNode;
}
export declare const ConnectedTextComponent: import("react-redux").ConnectedComponent<typeof TextComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<TextComponent> | undefined;
    contextType?: import("../../../types").ContextType | undefined;
    fixedHeight?: number | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    bind?: any;
    elementId: string;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    parentElementId?: string | undefined;
    level?: number | undefined;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    recordContext?: any;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedTextComponent;
//# sourceMappingURL=text-component.d.ts.map