import { addDisabledToProperties, addMaxLengthToProperties } from '../../../utils/data-type-utils';
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { TextAreaControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class TextAreaDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = TextAreaControlObject;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addMaxLengthToProperties({ dataType, propertyDetails, properties });
        addDisabledToProperties({
            propertyDetails,
            dataType,
            properties,
        });
        return properties;
    }
}
/**
 * Initializes the decorated member as a [TextArea]{@link TextAreaControlObject} field with the provided properties
 *
 * @param properties The properties that the [TextArea]{@link TextAreaControlObject} field will be initialized with
 */
export function textAreaField(properties) {
    return standardDecoratorImplementation(properties, TextAreaDecorator, FieldKey.TextArea);
}
export function textAreaFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=text-area-decorator.js.map